<?php
$xml = '<concerts><concert><title>Czarodziejski flet</title><time>1329636600</time></concert><concert><title>Cztery pory roku Vivaldiego</title><time>1329291000</time></concert><concert><title>Requiem Mozarta</title><time>1330196400</time></concert></concerts>';

$concert_list = simplexml_load_string($xml);
print_r($concert_list);

/* Wynik:
SimpleXMLElement Object
(
    [concert] => Array
        (
            [0] => SimpleXMLElement Object
                (
                    [title] => Czarodziejski flet
                    [time] => 1329636600
                )

            [1] => SimpleXMLElement Object
                (
                    [title] => Cztery pory roku Vivaldiego
                    [time] => 1329291000
                )

            [2] => SimpleXMLElement Object
                (
                    [title] => Requiem Mozarta
                    [time] => 1330196400
                )

        )

)
*/

// Wyświetlenie listy koncertów
echo "<table>\n";
foreach($concert_list as $concert) {
  echo "<tr>\n";
  echo "<td>" . $concert->title . "</td>\n";
  echo "<td>" . date('g:i, jS M',(string)$concert->time) . "</td>\n";

  echo "</tr>\n";
}
echo "</table>\n";

// Wyświetlenie tytułu drugiego koncertu
echo "Koncert specjalny: " . $concert_list->concert[1]->title;
?>